﻿{$zerobasedstrings}
var path := 'OSH-W97frc.txt';
var words: array of string;

function Min3(a, b, c: integer) := Min(Min(a, b), c);

function GetDistance(s,t: string ): integer;
begin
   var n := s.Length;
   var m := t.Length;
   if (n = 0) then exit(m);
   if (m = 0) then exit(n);

   // вспомогательный массив:
   var distance := new integer[n + 1, m + 1];
   var cost := 0;
   // заполняем массив исходными данными:
   for var i := 0 to n do distance[i, 0] := i;
   for var j := 0 to m do distance[0, j] := j;

   // вычисляем минимальное расстояние между словами:
   for var i := 1 to n do begin
       for var j := 1 to m do begin
           cost := (t.Substring(j - 1, 1) = s.Substring(i - 1, 1) ? 0 : 1);
           distance[i, j] := Min3(distance[i - 1, j] + 1,
                                  distance[i, j - 1] + 1,
                                  distance[i - 1, j - 1] + cost);
       end;
   end;
   Result := distance[n, m];
end;

   
// ПОДБИРАЕМ БЛИЗКИЕ СЛОВА ДЛЯ s
procedure Lev(s: string; num: integer);
begin
   var str := s + ' >';
   var flg := False;
   // просматриваем весь список:
   foreach var w in words do begin
      var m := GetDistance(w, s);
      // нашли похожее слово:
      if (m = num) then begin
          str += ' ' + w;
          flg := True;
      end;
   end;
   if (flg) then
       Writeln($' {str}')
   else
      Writeln($' Похожих слов нет!');     
   //foreach var w in words do begin
   //   Writeln($' {w} {w[0]}');
   //end;
   Writeln;  
end;


begin
   Writeln(' Алгоритм Левенштейна');
   Writeln;
   words := ReadAllLines(path);
   
   var n := 1;   
   while True do begin
      var s := ReadString.ToUpper;   
      Lev(s, n);    
   end;
end.
